#ifndef __ITimedObject__
#define __ITimedObject__

// We need to include on mac for the definition of an interface
#ifndef WIN32
#include <Basics/ICountedObject.hpp>
using Exponent::Basics::ICountedObject;
#endif

namespace Exponent
{
	namespace GUI
	{
		namespace Basics
		{
			/**
			 * @interface ITimedObject ITimedObject.hpp
			 * @brief Enables a class to recieve timer messages
			 *
			 * @date 18/10/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: ITimedObject.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface ITimedObject
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				ITimedObject() { }
				
				/**
				 * Destruction
				 */
				virtual ~ITimedObject() { }

//	===========================================================================

				/**
				 * Notification of your timer expiring
				 */
				virtual void timerExpired() = 0;

				/**
				 * Get the id 
				 * @retval long The unique Timer id
				 * @note Negative numbers are reserved for system classes. Use positive numbers ONLY!!
				 */
				virtual long getTimerId() const = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of ITimedObject.hpp